from codeable_detectors.basic_detectors import MatchesAcrossMultipleFilesDetector
from codeable_detectors.evidences import Evidences, FailedEvidence, LinkEvidence
from codeable_detectors.go.go_detectors import GoImportLink
from codeable_detectors.utils import extend_lists_in_keyword_args


class GoInstanaLink(MatchesAcrossMultipleFilesDetector):
    def __init__(self):
        super().__init__([GoImportLink("github.com/instana/go-sensor"),
                          GoImportLink("github.com/opentracing/opentracing-go")])

    def detect(self, directory, **kwargs):
        extend_lists_in_keyword_args(kwargs, "link_types", "http2")
        extend_lists_in_keyword_args(kwargs, "technology_types", "instana")
        evidences = super().detect(directory)
        if evidences.have_failed():
            return evidences
        elif evidences.is_empty():
            return FailedEvidence("no evidences for all codeable_detectors of go instana link found")
        return Evidences(LinkEvidence(evidences.get_all_matches()).set_properties(kwargs=kwargs))
